<?php
/**
 * Admin Page View
 *
 * @package SafeFontsAdobeConnect
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$sfac_adobe_connect = \Chrmrtns\SafeFontsAdobeConnect\AdobeConnect::get_instance();
$sfac_project_id = $sfac_adobe_connect->get_project_id();
$sfac_fonts = $sfac_adobe_connect->get_fonts();
$sfac_is_connected = !empty($sfac_project_id) && !empty($sfac_fonts);
?>

<div class="wrap sfac-wrap">
    <h1><?php esc_html_e('Adobe Fonts', 'safefonts-adobe-connect'); ?></h1>

    <div class="sfac-notice sfac-notice-warning">
        <span class="dashicons dashicons-warning"></span>
        <div>
            <strong><?php esc_html_e('External CDN Notice', 'safefonts-adobe-connect'); ?></strong>
            <p><?php esc_html_e('Adobe Fonts are loaded from Adobe\'s CDN servers. This means:', 'safefonts-adobe-connect'); ?></p>
            <ul>
                <li><?php esc_html_e('User IP addresses are sent to Adobe', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('A cookie consent banner may be required for GDPR compliance', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Fonts require an active internet connection', 'safefonts-adobe-connect'); ?></li>
            </ul>
            <p><em><?php esc_html_e('For fully GDPR-compliant fonts, use self-hosted fonts in SafeFonts Pro.', 'safefonts-adobe-connect'); ?></em></p>
        </div>
    </div>

    <div class="sfac-notice sfac-notice-info">
        <span class="dashicons dashicons-info"></span>
        <div>
            <strong><?php esc_html_e('FSE / Block Theme Limitation', 'safefonts-adobe-connect'); ?></strong>
            <p><?php esc_html_e('Adobe Fonts will NOT appear in the WordPress Font Library picker (Site Editor → Styles → Typography). This is an Adobe licensing limitation - they don\'t allow font file downloads, only CDN streaming.', 'safefonts-adobe-connect'); ?></p>
            <p><?php esc_html_e('Fonts are loaded and will render. Apply them via custom CSS or inline styles.', 'safefonts-adobe-connect'); ?></p>
        </div>
    </div>

    <?php if ($sfac_is_connected): ?>
        <!-- Connected State -->
        <div class="sfac-card sfac-card-connected">
            <div class="sfac-card-header">
                <span class="sfac-status sfac-status-connected">
                    <span class="dashicons dashicons-yes-alt"></span>
                    <?php esc_html_e('Connected', 'safefonts-adobe-connect'); ?>
                </span>
                <code><?php echo esc_html($sfac_project_id); ?></code>
            </div>

            <h3><?php esc_html_e('Active Adobe Fonts', 'safefonts-adobe-connect'); ?></h3>

            <table class="widefat sfac-fonts-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Font Name', 'safefonts-adobe-connect'); ?></th>
                        <th><?php esc_html_e('CSS Name', 'safefonts-adobe-connect'); ?></th>
                        <th><?php esc_html_e('Weights', 'safefonts-adobe-connect'); ?></th>
                        <th><?php esc_html_e('Preview', 'safefonts-adobe-connect'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($sfac_fonts as $sfac_font): ?>
                        <tr>
                            <td><strong><?php echo esc_html($sfac_font['name']); ?></strong></td>
                            <td><code><?php echo esc_html($sfac_font['css_name']); ?></code></td>
                            <td><?php echo esc_html(implode(', ', $sfac_font['weights'])); ?></td>
                            <td style="font-family: <?php echo esc_attr($sfac_font['css_name']); ?>; font-size: 16px;">
                                <?php esc_html_e('The quick brown fox jumps over the lazy dog.', 'safefonts-adobe-connect'); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <div class="sfac-actions">
                <button type="button" class="button" id="sfac-refresh" data-project-id="<?php echo esc_attr($sfac_project_id); ?>">
                    <span class="dashicons dashicons-update"></span>
                    <?php esc_html_e('Refresh Fonts', 'safefonts-adobe-connect'); ?>
                </button>
                <button type="button" class="button button-link-delete" id="sfac-disconnect">
                    <?php esc_html_e('Disconnect', 'safefonts-adobe-connect'); ?>
                </button>
            </div>
        </div>

        <div class="sfac-card">
            <h3><?php esc_html_e('How to Use', 'safefonts-adobe-connect'); ?></h3>

            <h4><?php esc_html_e('Builders with Dropdown Integration', 'safefonts-adobe-connect'); ?></h4>
            <p><?php esc_html_e('Fonts appear in font-family dropdowns:', 'safefonts-adobe-connect'); ?></p>
            <ul>
                <li><?php esc_html_e('Elementor - Look for "Adobe Fonts (CDN)" group', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Astra - Available in Customizer typography', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Kadence Theme & Blocks - Available in font settings', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Bricks, Beaver Builder, Divi - Available in typography controls', 'safefonts-adobe-connect'); ?></li>
            </ul>

            <h4><?php esc_html_e('All Other Themes & Builders', 'safefonts-adobe-connect'); ?></h4>
            <p><?php esc_html_e('Adobe Fonts CSS is loaded everywhere. Use the CSS font name directly:', 'safefonts-adobe-connect'); ?></p>
            <ul>
                <li><strong><?php esc_html_e('Etch:', 'safefonts-adobe-connect'); ?></strong> <?php esc_html_e('Type the CSS name in typography field', 'safefonts-adobe-connect'); ?></li>
                <li><strong><?php esc_html_e('GeneratePress, Spectra, Blocksy, Brizy:', 'safefonts-adobe-connect'); ?></strong> <?php esc_html_e('Use custom CSS or type font name', 'safefonts-adobe-connect'); ?></li>
                <li><strong><?php esc_html_e('FSE / Block Themes:', 'safefonts-adobe-connect'); ?></strong> <?php esc_html_e('Use custom CSS in theme.json or Customizer', 'safefonts-adobe-connect'); ?></li>
                <li><strong><?php esc_html_e('Any theme:', 'safefonts-adobe-connect'); ?></strong> <code>font-family: <?php echo esc_html($sfac_fonts ? reset($sfac_fonts)['css_name'] : 'your-font-name'); ?>;</code></li>
            </ul>
        </div>

    <?php else: ?>
        <!-- Not Connected State -->
        <div class="sfac-card">
            <h2><?php esc_html_e('Connect Adobe Fonts', 'safefonts-adobe-connect'); ?></h2>
            <p><?php esc_html_e('Enter your Adobe Fonts Web Project ID to load fonts from your Adobe account.', 'safefonts-adobe-connect'); ?></p>

            <div class="sfac-connect-form">
                <label for="sfac-project-id">
                    <strong><?php esc_html_e('Web Project ID', 'safefonts-adobe-connect'); ?></strong>
                </label>
                <div class="sfac-input-group">
                    <input type="text"
                           id="sfac-project-id"
                           placeholder="abc1def"
                           maxlength="7"
                           pattern="[a-z0-9]{7}"
                    />
                    <button type="button" class="button button-primary" id="sfac-fetch-fonts">
                        <?php esc_html_e('Fetch Fonts', 'safefonts-adobe-connect'); ?>
                    </button>
                </div>
                <p class="description">
                    <?php
                    printf(
                        /* translators: %s: link to Adobe Fonts */
                        esc_html__('Find your Web Project ID at %s under "Web Projects".', 'safefonts-adobe-connect'),
                        '<a href="https://fonts.adobe.com/my_fonts#web_projects-section" target="_blank">fonts.adobe.com</a>'
                    );
                    ?>
                </p>
            </div>

            <div id="sfac-fonts-preview" style="display: none;">
                <h3><?php esc_html_e('Fonts Found', 'safefonts-adobe-connect'); ?></h3>
                <div id="sfac-fonts-list"></div>
                <div class="sfac-actions">
                    <button type="button" class="button button-primary" id="sfac-save-fonts">
                        <?php esc_html_e('Connect These Fonts', 'safefonts-adobe-connect'); ?>
                    </button>
                </div>
            </div>
        </div>

        <div class="sfac-card sfac-card-help">
            <h3><?php esc_html_e('How to Get Your Web Project ID', 'safefonts-adobe-connect'); ?></h3>
            <ol>
                <li><?php esc_html_e('Go to fonts.adobe.com and sign in', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Click "Web Projects" in the top menu', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Create a new project or select an existing one', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Add fonts to your project', 'safefonts-adobe-connect'); ?></li>
                <li><?php esc_html_e('Copy the 7-character Project ID (e.g., "abc1def")', 'safefonts-adobe-connect'); ?></li>
            </ol>
        </div>
    <?php endif; ?>
</div>
