<?php
/**
 * Plugin Name: SafeFonts Adobe Connect
 * Plugin URI: https://safefonts.com/adobe-connect
 * Description: Adobe Fonts (TypeKit) integration for SafeFonts Pro. Adds support for Adobe Web Projects - loads fonts from Adobe CDN (requires user consent for GDPR).
 * Version: 1.0.0
 * Requires at least: 6.2
 * Requires PHP: 7.4
 * Author: Chris Martens
 * Author URI: https://chris-martens.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: safefonts-adobe-connect
 * Domain Path: /languages
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('CHRMRTNS_SFAC_VERSION', '1.0.0');
define('CHRMRTNS_SFAC_PLUGIN_FILE', __FILE__);
define('CHRMRTNS_SFAC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CHRMRTNS_SFAC_PLUGIN_URL', plugin_dir_url(__FILE__));

/**
 * Check if SafeFonts Pro is active
 *
 * @return bool
 */
function chrmrtns_sfac_is_safefonts_pro_active() {
    return defined('CHRMRTNS_SAFEFONTS_PRO_VERSION');
}

/**
 * Admin notice if SafeFonts Pro is not active
 */
function chrmrtns_sfac_missing_dependency_notice() {
    ?>
    <div class="notice notice-error">
        <p>
            <strong><?php esc_html_e('SafeFonts Adobe Connect', 'safefonts-adobe-connect'); ?>:</strong>
            <?php
            printf(
                /* translators: %s: SafeFonts Pro plugin name */
                esc_html__('This add-on requires %s to be installed and activated.', 'safefonts-adobe-connect'),
                '<strong>SafeFonts Pro</strong>'
            );
            ?>
        </p>
    </div>
    <?php
}

/**
 * Initialize the plugin
 */
function chrmrtns_sfac_init() {
    // Check for SafeFonts Pro dependency
    if (!chrmrtns_sfac_is_safefonts_pro_active()) {
        add_action('admin_notices', 'chrmrtns_sfac_missing_dependency_notice');
        return;
    }

    // Load the main class
    require_once CHRMRTNS_SFAC_PLUGIN_DIR . 'includes/class-adobe-connect.php';

    // Initialize
    \Chrmrtns\SafeFontsAdobeConnect\AdobeConnect::get_instance();
}
add_action('plugins_loaded', 'chrmrtns_sfac_init', 20);

/**
 * Activation hook
 */
function chrmrtns_sfac_activate() {
    if (!chrmrtns_sfac_is_safefonts_pro_active()) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die(
            esc_html__('SafeFonts Adobe Connect requires SafeFonts Pro to be installed and activated.', 'safefonts-adobe-connect'),
            esc_html__('Plugin Activation Error', 'safefonts-adobe-connect'),
            array('back_link' => true)
        );
    }
}
register_activation_hook(__FILE__, 'chrmrtns_sfac_activate');
